<!DOCTYPE html>
<html>
<head>
    @php($site=getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>


    <title>{{$page_tittle}}</title>

    <style>

       @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .st-image {
            text-align: center;
            width: 60px;
            height: 60px;
            border-radius:0;
            border: 1px solid #0b0b0b;
        }

        .txt-left {
            text-align: left;
        }
        .txt-center {
            text-align: center;
        }

        td{
            font-size: 10px;
        }

    </style>

</head>
<body>

@include('default.site.layout.pdf-header')



<table class="data-table" cellspacing="0" border="1" width="100%;">
    <thead>
    <tr>
        <th style="text-align: center">S/L</th>
        <th style="text-align: center">
            <nobr>User Id</nobr>
        </th>
        <th style="text-align: center">
            <nobr>Name</nobr>
        </th>
        <th style="text-align: center">
             Roll
        </th>
        <th style="text-align: center">
            <nobr> Father Name</nobr>
        </th>
        <th style="text-align: center">
            <nobr> Mother Name</nobr>
        </th>
        <th style="text-align: center">
            Shift
        </th>
        <th style="text-align: center">
            Class
        </th>
        <th style="text-align: center">
            Group & Sec.
        </th>
        <th>
            DOB
        </th>
        <th style="text-align: center">
            Mobile
        </th>
        <th style="text-align: center">Pic</th>
    </tr>
    </thead>

    <tbody>
    @foreach($card_data as $key => $value)
        <tr>
            <td style="text-align: center">{{$key+1}}</td>
            <td style="text-align: center">
                    <b> ({{$value['username']}})</b>
                
            </td>

            <td style="text-align: center">
                <nobr>  {{$value['full_name'] ?? '--'}}  </nobr>
            </td>

            <td style="text-align: center">
                {{$value['student_roll_number'] ?? '--'}}
            </td>

            <td style="text-align: center">
                <nobr>  {{$value['father_name'] ??  '--'}}</nobr>
            </td>

            <td style="text-align: center">
                <nobr>    {{$value['mother_name'] ?? '--'}}</nobr>
            </td>
            <td style="text-align: center">
                {{$value['shift_name'] ?? '--'}}
            </td>
            <td style="text-align: center">
                {{$value['class_name'] ?? '--'}}
            </td>
            <td style="text-align: center">

                @if($value['group_name'])
                    {{$value['group_name'] }}
                @endif

                {{$value['section_name'] ?? '--'}}
            </td>

            <td style="text-align: center">
                <nobr>{{ date('d M Y', strtotime($value['date_of_birth'] ?? '1970-12-16'))}}</nobr>
            </td>
            <td style="text-align: center">
                 {{$value['contact_number'] ?? '--'}}
            </td>
            <td style="text-align: center">

                    @if(file_exists(public_path("uploads").'/'.$value['latest_photo']))
                        <img class="st-image"
                             src="{{asset("uploads").'/'.$value['latest_photo'] ?? 'image-not.png'}}">
                    @else
                        <img class="st-image"
                             src="{{asset("uploads").'/image-not.png'}}">
                    @endif

            </td>
        </tr>
    @endforeach

    </tbody>
</table>
            


</body>


<style>

    @page {
        size: landscape;
        margin: 0px;

    }

    body {
        margin: 5px;
    }

</style>

</html>












